close all, clear all, clc

T_init = 26;
run(append('../Vehicle data/ElectricVehicleThermalManagementParameters'))

%% R0 as a linear function temperature

% one R0 for each temperature
R0_mean = mean(battery_R0_LUT);
r_pol_coef = polyfit( battery_temperature_LUT , R0_mean , 1 ); % 2nd degree polynomial

% Plot the real R0 and its approximation
figure();  hold on; box on;
for T_idx = 1:length(battery_temperature_LUT)
    T = battery_temperature_LUT(T_idx);
    plot(battery_SOC_LUT,battery_R0_LUT(:,T_idx),'LineWidth',2);
    plot(battery_SOC_LUT,polyval(r_pol_coef,T).*ones(size(battery_SOC_LUT)),'--','LineWidth',2);
end
xlabel('SOC (-)')
ylabel('R_0 (Ohm)')
set(findall(gcf,'-property','FontSize'),'FontSize',16)

% save('R0_linear_function_coefficient','r_pol_coef');


%% R0 polynomial approximation as function of temperature
% one R0 for each temperature
R0_mean = mean(battery_R0_LUT);
r_pol_coef = polyfit( battery_temperature_LUT , R0_mean , 2 ); % 2nd degree polynomial

% Plot the real R0 and its approximation
figure();  hold on; box on;
for T_idx = 1:length(battery_temperature_LUT)
    T = battery_temperature_LUT(T_idx);
    plot(battery_SOC_LUT,battery_R0_LUT(:,T_idx),'LineWidth',2);
    plot(battery_SOC_LUT,polyval(r_pol_coef,T).*ones(size(battery_SOC_LUT)),'--','LineWidth',2);
end
xlabel('SOC (-)')
ylabel('R_0 (Ohm)')
set(findall(gcf,'-property','FontSize'),'FontSize',16)

save('R0_linear_function_coefficient','r_pol_coef');
